/*= DIGISTANT 4422 ========================================================*/
/* LabWindows Instrument Driver                                            */
/* Original Release: V1.0  13.10.94                                        */
/*          Release: V1.1  14.11.95 /MW                                    */
/*          Release: V1.2   1.04.96 /MW                                    */
/*          Release: V1.3   5.05.98 /MW    (P-Modul)                       */
/*          Release: V1.4  01.02.02 /MT                                    */
/*			Release: V1.5  26.08.2002 /MT	(CloseCom hinzugefgt)		   */
/*			Release: V1.6  25.11.2002 /MT   (Var. 'diff' vorintitialisiert */
/*			 in Funktion bp4422_get_eoc, _get_p_eoc, _start_measurement	   */
/*			 rs232err wurde in Funktion bp4422_open_instr nach CloseCom    */
/*			 bergeben													   */
/*																		   */
/* By: M.Westermann                                                        */
/* Originally written in C                                                 */
/* Modification History: None                                              */
/*=========================================================================*/


 /*---- LabWindows CVI Header----*/
 #include <utility.h>
 #include <rs232.h>
 #include <formatio.h>
 #include <ansi_c.h>

#include "bp4422.h"


/*= STATIC VARIABLES ======================================================*/
static int setup_first ;                  /* remark the first initial*/
static double std_timeout;                /* remark the user timeout*/
static int max_bcc_repeat;                /* Max-Bcc-Repeat */
static int bcc_repeat;                    /* Bcc-Repeat counter*/
static int bcc_state;                     /* Blockcheck state ON or OFF*/
static int instr_cnt;
static int bp4422_err;

static int address[bp4422_MAX_INSTR + 1];  /*Adress*/
static char cmd[bp4422_MAX_CMD+1];
static char buf[bp4422_MAX_CMD+1];
static char out_buf[bp4422_MAX_CMD+1];       /* buffer for serial send */
static char in_buf[bp4422_MAX_CMD+1];        /* buffer for serial receive */
static char swap_buf[bp4422_MAX_CMD+1];      /* global serial buffer */
static int port_addr[4] ;                    /* RS232-Port Array*/
static int int_level[4] ;                    /* RS232-Interrupt-Level Array*/
static int dev_port[bp4422_MAX_INSTR];       /* Device Port*/
static int dev_group_addr[bp4422_MAX_INSTR]; /* Device Group serial Adress*/
static int dev_user_addr[bp4422_MAX_INSTR];  /* Device User serial Adress */
static int tc_type_flag;                     /* merken zum Starten der Messung*/
static int rtd_type_flag;                    /* merken zum Starten der Messung*/

static char * volt_range[5];
static char * curr_range[3];
static char * res_range[3];
static char * io_mode[3];

static char * system_keyboard[2];
static char * cal_state[2];
static char * cal_curr_low[4];
static char * cal_curr_high[4];
static char * cal_volt_low[8];
static char * cal_volt_high[8];
static char * rtd[5];
static char * rtd_currmode[2];
static char * rtd_range[2];
static char * measure_mode[2];
static char * tc[14];
static char * tc_rj_output[5];
static char * tc_rj_input[5];
static char * rtd_unit[4];
static char * tc_unit[3];

static char * ground[3];
static char * datalogger_start[2];

static char * ramp_mode[3];
static char * ramp_start[2];
static char * ramp_step[2];
static char * ramp1_wave[2];
static char * ramp2_wave[2];


/*= UTILITY ROUTINES ======================================================*/
int _VI_FUNC bp4422_invalid_integer_range (int, int, int, int);
int _VI_FUNC bp4422_invalid_real_range (double, double, double, int);
//int _VI_FUNC bp4422_config_input_type(int instID,int type,int rtd_type,int tc_type);
void bp4422_setup_arrays (void);
int _VI_FUNC bp4422_get_eoc(int );
int _VI_FUNC bp4422_get_p_eoc(int );
int _VI_FUNC bp4422_calculate_bcc(char* );
int _VI_FUNC bp4422_send_x3_28(int,char*,char*);
int _VI_FUNC bp4422_send_x3_28_message(int,char*,char*);
int _VI_FUNC bp4422_receive_x3_28(int,char*,char*,char*);
int _VI_FUNC bp4422_receive_and_ack(int,char*);
int _VI_FUNC bp4422_close_instr (int);
int _VI_FUNC bp4422_device_closed (int);
int _VI_FUNC bp4422_open_instr(int,int,int,int);
void change_unit(double wert,char* einheit,double* value,char *unit);
//void change_character_pc_disp4422(char* source,char *dest);
//void change_character_disp4422_pc(char* source,char *dest);

int bp4422_status_quest_reg;

/*=========================================================================*/
/* This function opens a com port for the instrument module                */
/*=========================================================================*/
int _VI_FUNC bp4422_init(int port,int baud_rate,double timeout,int set_bcc_state,
                   int g_addr,int u_addr,char* model,int reset_flag,
                   int *instrID)
{
    int ID;

	bp4422_err = 0;
    bp4422_setup_arrays ();

    if (bp4422_invalid_integer_range (port, 1,4, -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (baud_rate, 1200, 19200, -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_real_range (timeout, 0.0F, 72000.0F, -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (set_bcc_state, 0,1, -4) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (g_addr, 0,15, -5) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (u_addr, 0,15, -6) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (reset_flag, 0,1, -7) != 0)
     return bp4422_err;

    ID = bp4422_open_instr(port,baud_rate,g_addr,u_addr);
    if(ID <= 0)
     return bp4422_err;

    SetComTime (port, timeout);
    std_timeout = timeout;

    if (rs232err != 0)
        return (rs232err);

    max_bcc_repeat = 5;       /* default*/
    bcc_state = set_bcc_state;

    if (bp4422_receive_scpi(ID,"*IDN?",model) != 0)
    {
     bp4422_close_instr(ID);
     return bp4422_err;
    }
    if (reset_flag == 1)
    {
     if(bp4422_send_scpi(ID,"*RST") != 0) /* Reset*/
     {
      bp4422_close_instr(ID);
      return bp4422_err;
     }
    }

    *instrID = ID;

    return(0);
}
/* ========================================================================= */
/*  This function switch the calculate state ON/OFF                          */
/* ========================================================================= */
int _VI_FUNC bp4422_calc_state(int instrID,int state)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (state, 0, 1,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<CALC:LIM:STAT %i\n",state);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return (0);
}
/* ========================================================================= */
/*  This function reset the calculate min/max values                         */
/* ========================================================================= */
int _VI_FUNC bp4422_calc_reset(int instrID)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<CALC:LIM:CLE\n");
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return (0);
}

/* ========================================================================= */
/*  This function configure the Input or Output Mode                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_config(int instrID,int dmode,int rtd_type,int rtdunit,int tc_type,int tcunit)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (dmode, 0, 2,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (rtd_type, 0, 4,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (rtdunit, 0, 3,  -4) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (tc_type, 0, 13,  -5) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (tcunit, 0, 3,  -6) != 0)
     return bp4422_err;


     /* wegen Probleme in 4422 wird bei nchstem Update behoben von CS*/
    if (bp4422_send_scpi (instrID, "CONF:VOLT") != 0)
     return bp4422_err;

    if(dmode == 0)
    {
     Fmt (cmd, "%s<INST:COUP ALL\n");
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }
    else
    {
     Fmt (cmd, "%s<INST:COUP NONE\n");
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     if (bp4422_send_scpi (instrID,io_mode[dmode-1]) != 0)
      return bp4422_err;
    }


    if(bp4422_send_scpi (instrID, rtd_unit[rtdunit]) != 0)
     return bp4422_err;

    if(bp4422_send_scpi (instrID, tc_unit[tcunit]) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID,tc[tc_type]) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID,rtd[rtd_type] ) != 0)
     return bp4422_err;

    tc_type_flag = tc_type;         /* merken zum Starten der Messung*/
    rtd_type_flag = rtd_type;

    return (0);
}
/* ========================================================================= */
/*  This function configure the pressur module                               */
/* ========================================================================= */
int _VI_FUNC bp4422_config_p_module(int instrID,int module_no,char* s_no,
                           char* cal_date,char* unit,
                           double zero_voltage, double zero_p_value,
                           double final_voltage, double final_p_value,
                           double max_value)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (module_no, 0, 9,  -2) != 0)
     return bp4422_err;

    change_character_pc_disp4422(s_no,buf); 

    Fmt (cmd, "%s<ROUT:MOD:SERN %d,%s",module_no,buf);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<ROUT:MOD:SCAL %d,%f,%f,%f,%f",module_no,zero_voltage,zero_p_value,final_voltage,final_p_value);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    change_character_pc_disp4422(unit,buf); 
    Fmt (cmd, "%s<ROUT:MOD:UNIT %d,%s",module_no,buf);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;
     
    Fmt (cmd, "%s<ROUT:MOD:DATE %d,%s",module_no,cal_date);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;
     
    Fmt (cmd, "%s<ROUT:MOD:MAX %d,%f",module_no,max_value);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;
     
    return (0); 
}
/* ========================================================================= */
/*  This function configure the pressur module                               */
/* ========================================================================= */
int _VI_FUNC bp4422_get_config_p_module(int instrID,int module_no,char* name,char* s_no,
                           char* cal_date,char* unit,
                           double* zero_voltage, double* zero_p_value,
                           double* final_voltage, double* final_p_value,
                           double* max_value)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (module_no, 0, 9,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<ROUT:MOD:DEF? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    change_character_disp4422_pc(buf,name); 
    
   	if(strcmp(name,"         ") == 0) /* Wenn 9 Zeichen Space sind dan nicht aktiv*/   
     return 0;
    
    Fmt (cmd, "%s<ROUT:MOD:SERN? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    change_character_disp4422_pc(buf,s_no);  
	
	
    Fmt (cmd, "%s<ROUT:MOD:SCAL? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    Scan(buf,"%s>%f,%f,%f,%f",zero_voltage,zero_p_value,final_voltage,final_p_value);
    
    Fmt (cmd, "%s<ROUT:MOD:UNIT? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    change_character_disp4422_pc(buf,unit);   
    
    
    Fmt (cmd, "%s<ROUT:MOD:DATE? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    change_character_disp4422_pc(buf,cal_date);        
    
    Fmt (cmd, "%s<ROUT:MOD:MAX? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
    Scan(buf,"%s>%f",max_value); 
     
    return (0); 
}

/* ========================================================================= */
/*  This function configure the Input or Output Mode                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_config_grounding(int instrID,int gmode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (gmode, 0, 2,  -2) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID, ground[gmode]) != 0)
      return bp4422_err;
    return (0);
}

/* ========================================================================= */
/*  This function configure the output tc-RefJunction                       */
/* ========================================================================= */
int _VI_FUNC bp4422_config_output_tc_rj(int instrID,int rj_mode,double tmin,double tmax)
{
    bp4422_err = 0;
    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
      return bp4422_err;
    if (bp4422_invalid_integer_range (rj_mode, 0, 4,  -2) != 0)
      return bp4422_err;


    Fmt (cmd, "%s<SOUR:TCO:REFJ %s",tc_rj_output[rj_mode]);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    switch(rj_mode)
    {
     case 0:     /*RJ-Int*/
      break;
     case 1:     /* RJ-Man*/
      Fmt (cmd, "%s<SOUR:TCO:REFJ:TMAN %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
     case 2:     /* RJ-Auto*/
      break;
     case 3:     /* RJ-4-20mA*/
      Fmt (cmd, "%s<SOUR:TCO:REFJ:TMIN4 %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:TCO:REFJ:TMAX4 %f",tmax);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
     case 4:     /* RJ-0-20mA*/
      Fmt (cmd, "%s<SOUR:TCO:REFJ:TMIN0 %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:TCO:REFJ:TMAX0 %f",tmax);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
    }
    return (0);
}

/* ========================================================================= */
/*  This function configure the output tc-RefJunction                       */
/* ========================================================================= */
int _VI_FUNC bp4422_config_input_tc_rj(int instrID,int rj_mode,double tmin,double tmax)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
      return bp4422_err;
    if (bp4422_invalid_integer_range (rj_mode, 0, 4,  -2) != 0)
      return bp4422_err;


    Fmt (cmd, "%s<SENS:TCO:REFJ %s",tc_rj_input[rj_mode]);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    switch(rj_mode)
    {
     case 0:     /*RJ-Int*/
      break;
     case 1:     /* RJ-Man*/
      Fmt (cmd, "%s<SENS:TCO:REFJ:TMAN %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
     case 2:     /* RJ-Extern*/
      break;
     case 3:     /* RJ-4-20mA*/
      Fmt (cmd, "%s<SENS:TCO:REFJ:TMIN4 %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SENS:TCO:REFJ:TMAX4 %f",tmax);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
     case 4:     /* RJ-0-20mA*/
      Fmt (cmd, "%s<SENS:TCO:REFJ:TMIN0 %f",tmin);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SENS:TCO:REFJ:TMAX0 %f",tmax);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      break;
    }
    return (0);
}
int _VI_FUNC bp4422_config_input_type(int instrID,int type,int rtd_type,int tc_type)
/* ========================================================================= */
/*  This function config input type                                                  */
/* ========================================================================= */
{
    bp4422_err = 0;
    
    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (type, 0, 6,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (rtd_type, 0, 4,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (tc_type, 0, 13,  -4) != 0)
     return bp4422_err;


    switch(type)
    {
     case 0:            /* Voltage*/
      Fmt (cmd, "%s<CONF:VOLT");
      break;
     case 1:            /* Current*/
      Fmt (cmd, "%s<CONF:CURR");
      break;
     case 2:            /* FRTD*/
      Fmt (cmd, "%s<%s",rtd[rtd_type]);
      break;
     case 3:            /* TCouple*/
      Fmt (cmd, "%s<%s",tc[tc_type]);
      break;
     case 4:            /* Druck Messung*/
      Fmt (cmd, "%s<CONF:P");
      break;
     case 5:            /* Druck+Current Messung*/
      Fmt (cmd, "%s<CONF:P_Current");
      break;
     case 6:            /* Druck+Voltage Messung*/
      Fmt (cmd, "%s<CONF:P_Voltage");
      break;
      
    }

    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return 0;
}

/* ========================================================================= */
/*  This function output the voltage value                                   */
/* ========================================================================= */
int _VI_FUNC bp4422_set_value(int instrID,int type ,int range, double value)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
        return bp4422_err;

    if (bp4422_invalid_integer_range (type, 0, 3,  -2) != 0)
      return bp4422_err;

    switch(type)
    {
     case 0:           /* Voltage*/
      if (bp4422_invalid_integer_range (range, 0, 4,  -3) != 0)
       return bp4422_err;

      if(bp4422_send_scpi (instrID,volt_range[range] ) != 0)
       return bp4422_err;

	  Fmt (cmd, "%s<SOUR:VOLT %fV",value);
	  
      StringUpperCase (cmd);
	  if(bp4422_send_scpi (instrID,cmd) != 0)
       return bp4422_err;

      break;
     case 1:            /* Current*/
      if (bp4422_invalid_integer_range (range, 0, 2,  -3) != 0)
       return bp4422_err;

      if(bp4422_send_scpi (instrID,curr_range[range] ) != 0)
       return bp4422_err;

      /* bertragen in mA wegen Rundungsprobleme beim 4422*/
      Fmt (cmd, "%s<SOUR:CURR %fMA",value*1000.0F);
      if(bp4422_send_scpi (instrID,cmd) != 0)
       return bp4422_err;

      break;
     case 2:            /* Resistance*/
      if (bp4422_invalid_integer_range (range, 0, 2,  -3) != 0)
       return bp4422_err;

      if(bp4422_send_scpi (instrID,res_range[range] ) != 0)
       return bp4422_err;

      Fmt (cmd, "%s<SOUR:RES %f",value);
      if(bp4422_send_scpi (instrID,cmd) != 0)
       return bp4422_err;
      break;
     case 3:            /* TCouple*/
      if(bp4422_send_scpi (instrID,volt_range[0] ) != 0) /* Autorange*/
       return bp4422_err;

      Fmt (cmd, "%s<SOUR:TCO %f",value);
      if(bp4422_send_scpi (instrID,cmd) != 0)
       return bp4422_err;
      break;
    }
    return (0);
}

/* ========================================================================= */
/*  This function start the measure                                                  */
/* ========================================================================= */
int _VI_FUNC bp4422_start_measure(int instrID,int type)
{
    double t1,t2,diff;
    int ret;

    bp4422_err = 0;
	diff = 0.0F;								// Variablenwert initialisiert (MT/25.11.2002)

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (type, 0, 6,  -2) != 0)
     return bp4422_err;

	if(bp4422_config_input_type(instrID,type,rtd_type_flag,tc_type_flag) != 0)
     return bp4422_err;	
     
	
    Fmt (cmd, "%s<INIT");
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
      
    ret = bp4422_get_status(instrID);         /* status abfragen*/      
    
	return (ret);
	
		/* ab hier nicht weiter machen*/
    ret = -3;
    t1= Timer();                                /* startzeit merken */
    while((ret != 0) && (diff < 25.0F)) /* Kein Fehler oder Zeitlimit berschritten*/
    {
     Delay(0.1F);
     ret = bp4422_get_status(instrID);         /* status abfragen*/
     t2= Timer();
     diff = fabs(t2-t1);
/*     FmtOut("\nret %i  diff %f",ret,diff);*/
    }
    if(diff >= 25.0F)
     return (-3);

    return (ret);
}
/* ========================================================================= */
/*  This function the read measring String                                     */
/* ========================================================================= */
int _VI_FUNC bp4422_read_measure_string(int instrID,char *value )
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    if(bp4422_get_eoc(instrID) != 0) /* Warten auf EOC*/
     return bp4422_err;

    if(bp4422_receive_scpi(instrID,"fetch?",value) != 0)/* Messwert lesen */
     return bp4422_err;

    if(bp4422_get_status(instrID) != 0)
      return bp4422_err;

    

    return (0);
}

/* ========================================================================= */
/*  This function the measure                                                  */
/* ========================================================================= */
int _VI_FUNC bp4422_read_measure(int instrID,double *value,char* unit )
{
    double wert;
    char mw_buf[20],einheit[5];

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    if(bp4422_get_eoc(instrID) != 0) /* Warten auf EOC*/
     return bp4422_err;

    if(bp4422_receive_scpi(instrID,"fetch?",mw_buf) != 0)
      return bp4422_err;

    Scan(mw_buf,"%s>%f%s",&wert,einheit);
    change_unit(wert,einheit,value,unit);
    
    if(bp4422_get_status(instrID) != 0)
      return bp4422_err;

    
    return (0);
}
/* ========================================================================= */
/*  This function the read presure measring String                           */
/* ========================================================================= */
int _VI_FUNC bp4422_read_p_measure_string(int instrID,char *value )
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    if(bp4422_get_p_eoc(instrID) != 0) /* Warten auf EOC*/
     return bp4422_err;

	if(bp4422_receive_scpi(instrID,"fetch:p?",buf) != 0)/* Durck-Messwert lesen */
     return bp4422_err;
	change_character_disp4422_pc(buf,value);

    if(bp4422_get_status(instrID) != 0)
      return bp4422_err;

    

    return (0);
}

/* ========================================================================= */
/*  This function the presure measure                                        */
/* ========================================================================= */
int _VI_FUNC bp4422_read_p_measure(int instrID,double *value,char* unit )
{
	char mw_buf[20];

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    if(bp4422_get_p_eoc(instrID) != 0) /* Warten auf EOC*/
     return bp4422_err;

    if(bp4422_receive_scpi(instrID,"fetch:p?",mw_buf) != 0)
      return bp4422_err;


	Scan(mw_buf,"%s>%f%s",value,buf);
	change_character_disp4422_pc(buf,unit);

    if(bp4422_get_status(instrID) != 0)
    {
      /*printf("\n %s %d",mw_buf,bp4422_status_quest_reg);*/
      return bp4422_err;
	}
    /*printf("\n %s %d",mw_buf,bp4422_status_quest_reg);*/
    return (0);
}

/* ========================================================================= */
/*  This function stop the measure                                                  */
/* ========================================================================= */
int _VI_FUNC bp4422_stop_measure(int instrID)
{


    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<ABORT");
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;



    return (0);
}
/* ========================================================================= */
/*  This function select the the pressure module by no                       */
/* ========================================================================= */
int _VI_FUNC bp4422_select_p_module_no(int instrID,int module_no)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (module_no, 0, 9,  -2) != 0)
     return bp4422_err;
    
    Fmt (cmd, "%s<ROUT:MOD:SEL:NUMB %d",module_no);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     
    return (0); 
}
/* ========================================================================= */
/*  This function select the the pressure module by no                       */
/* ========================================================================= */
int _VI_FUNC bp4422_select_p_module_name(int instrID,char * name)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
     
    Fmt (cmd, "%s<ROUT:MOD:SEL:NAME %s",name);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    
     
    return (0); 
}

/* ========================================================================= */
/*  This function switch the tare state ON or OFF                            */
/* ========================================================================= */
int _VI_FUNC bp4422_tare_p_state(int instrID,int state )
{
    bp4422_err = 0;
    

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (state, 0, 1,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<SENS:REF:STAT %d",state);
    if(bp4422_send_scpi (instrID,cmd) != 0)
     return bp4422_err;

    return (0);
}
/* ========================================================================= */
/*  This function initate the tare measrement                                */
/* ========================================================================= */
int _VI_FUNC bp4422_tare_p_init(int instrID)
{
    bp4422_err = 0;
    

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    if(bp4422_send_scpi (instrID,"SENS:REF:INIT") != 0)
     return bp4422_err;

    return (0);
}

/* ========================================================================= */
/*  This function the presure measure                                        */
/* ========================================================================= */
int _VI_FUNC bp4422_get_tare_p_value(int instrID ,char* value)
{
    int meas_status,ret;
    bp4422_err = 0;
    
    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    ret = 0;
    while(ret != 1) 
    {

     if(bp4422_receive_scpi(instrID,"STAT:OPER:COND?",buf) != 0)
      return bp4422_err;
      
	 Scan(buf,"%s>%i",&meas_status);

     /*--------------- Messung berhaupt gestartet-------------*/
     if(!(meas_status & bp4422_DEVICE_MEASURING))
     {
      ret = 1;
      bp4422_err = 350;
     }
    
     /*--------------- Batterie-Messung Fertig -------------*/
     if(meas_status & bp4422_DEVICE_P_TARE_EOC)
     {
      ret = 1;
      bp4422_err = 0;
	 /* FmtOut("\n** P-Tare-EOC **");*/
     }
    } 
	if(bp4422_err != 0)
	 return bp4422_err;
	 
    if(bp4422_receive_scpi(instrID,"SENS:REF:FETC?",value) != 0)
      return bp4422_err;
    
    return (0);
    
}
/* ========================================================================= */
/*  This function get pressure module name                                  */
/* ========================================================================= */
int _VI_FUNC bp4422_store_p_module_name(int instrID,int module_no,char* name)
{
	bp4422_err = 0;

	change_character_pc_disp4422(name,buf);
	Fmt (cmd, "%s<ROUT:MOD:DEF %d,%s",module_no,buf);
	if (bp4422_send_scpi (instrID, cmd) != 0)
	 return bp4422_err;

	return (0);

}

/* ========================================================================= */
/*  This function get pressure module name  								*/
/* ========================================================================= */
int _VI_FUNC bp4422_get_p_module_name(int instrID,int module_no,char* name)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (module_no, 0, 9,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<ROUT:MOD:DEF? %d",module_no);
    if (bp4422_receive_scpi (instrID, cmd,buf) != 0)
     return bp4422_err;
	change_character_disp4422_pc(buf,name);

    return (0); 
}


/* ========================================================================= */
/*  This function the presure measure                                        */
/* ========================================================================= */
int _VI_FUNC bp4422_check_p_module_batterie(int instrID,char* value )
{
    int meas_status,ret;
	char mw_buf[50],batt_unit[10];
	double batterie_wert,wert;
	
    bp4422_err = 0;
    

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;


    if(bp4422_send_scpi(instrID,"DIAG:MOD:BATT:INIT") != 0) /* Batterie Messung starten*/
      return bp4422_err;
      
    ret = 0;
    while(ret != 1) 
    {

     if(bp4422_receive_scpi(instrID,"STAT:OPER:COND?",buf) != 0)
      return bp4422_err;
      
     Scan(buf,"%s>%i",&meas_status);
    
     /*--------------- Batterie-Messung Fertig -------------*/
     if(meas_status & bp4422_DEVICE_P_BATT_EOC)
     {
      ret = 1;
      bp4422_err = 0;
      /*FmtOut("\n** P-Batt-EOC **");*/
     }
    } 

	
	
    if(bp4422_receive_scpi(instrID,"DIAG:MOD:BATT:FETC?",mw_buf) != 0)
      return bp4422_err;

	Scan(mw_buf,"%s>%f%s",&wert,batt_unit);

	if(batt_unit[0] == 'M') /* mV*/
	{
	 batterie_wert = wert/1000.0;   /* in V umrechnen*/
	 batt_unit[0] = 'm';        /* mV klein schreiben*/
	}
	else
	 batterie_wert = wert;

	Fmt(value,"%s<%f%s",wert,batt_unit); /* zur bergabe zusammensetzen*/

	if(batterie_wert > 0.100)  /* > 100mV ist alles OK*/
	 bp4422_err = 0;
    else
     bp4422_err = 319;
    
    return (bp4422_err);
}

/* ========================================================================= */
/*  This function clear all datalogger values                                */
/* ========================================================================= */
int _VI_FUNC bp4422_clear_all_datalogger(int instrID)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    Fmt (cmd, "%s<DAT:CLE:ALL");
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    return 0;
}
/* ========================================================================= */
/*  This function clear  datalogger block value                              */
/* ========================================================================= */
int _VI_FUNC bp4422_clear_datalogger_block(int instrID,int block_nr)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (block_nr, 1, 256,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<DAT:CLE:BLOC %d",block_nr);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    return 0;
}

/* ========================================================================= */
/*  This function set the datalogger mode                                   */
/* ========================================================================= */
int _VI_FUNC bp4422_set_datalogger_mode(int instrID,int dmode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (dmode, 0, 1,  -2) != 0)
     return bp4422_err;
    
    if(dmode == 1)  /* wenn Datalogger An => Messung vorher starten*/
    {
     Fmt (cmd, "%s<INST:COUP NONE\n");
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     if (bp4422_send_scpi (instrID,io_mode[1]) != 0)   /* Only IN */
      return bp4422_err;


     Fmt (cmd, "%s<INIT");
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
	}

    Fmt (cmd, "%s<DAT:MODE %i",dmode);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
      
	
	if(dmode == 0)   /* wenn Datalogger Aus => Messung nachher stoppen*/
	{
     Fmt (cmd, "%s<ABORT");
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
	}
      
    return 0;
}
/* ========================================================================= */
/*  This function set the datalogger time                                   */
/* ========================================================================= */
int _VI_FUNC bp4422_set_datalogger_time(int instrID,double dtime)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_real_range (dtime, 0.0F, 3600.0,  -2) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<DAT:TIME %f",dtime);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    return 0;
}

/* ========================================================================= */
/*  This function set the datalogger Start/Stop                              */
/* ========================================================================= */
int _VI_FUNC bp4422_datalogger_start_stop(int instrID,int start)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (start, 0, 1,  -2) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID, datalogger_start[start]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function  step datalogger                                          */
/* ========================================================================= */
int _VI_FUNC bp4422_datalogger_step(int instrID)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    Fmt (cmd, "%s<DAT:STEP");
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    return 0;
}
/* ========================================================================= */
/*  This function the read datalogger average and deviation                  */
/* ========================================================================= */
int _VI_FUNC bp4422_datalogger_aver_devi(int instrID,int block_nr,double *average,
                                double *deviation,char* unit)
{
    char dummy[40],einheit[40];
    double wert;

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (block_nr, 1, 256,  -2) != 0)
     return bp4422_err;

    Fmt(cmd,"%s<DAT:BLOC:AVER? %i",block_nr);
    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;

    /*if(FindPattern (buf, 0, 10, "Leer", 0, 0) >= 0)*/


    if(buf[0] > '9')  /* Wenn keine Block-Nr dann Leer, Empty oder Vide =>leider ist es so!*/
     return 320;

    Scan(buf,"%s>%s %f%s",dummy,&wert,einheit);

    change_unit(wert,einheit,average,unit);

    Fmt(cmd,"%s<DAT:BLOC:DEV? %i",block_nr);
    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;
    Scan(buf,"%s>%s %f%s",dummy,&wert,einheit);
    change_unit(wert,einheit,deviation,unit);

    return (0);
}
/* ========================================================================= */
/*  This function the read datalogger min Max                                */
/* ========================================================================= */
int _VI_FUNC bp4422_datalogger_min_max(int instrID,int block_nr,double *min_value,
                            double *max_value,char* unit)
{
    char dummy[40],einheit[40];
    double wert;

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (block_nr, 1, 256,  -2) != 0)
     return bp4422_err;

    Fmt(cmd,"%s<DAT:BLOC:MIN? %i",block_nr);
    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;




    if(buf[0] > '9')  /* Wenn keine Block-Nr dann Leer, Empty oder Vide =>leider ist es so!*/
     return 320;

    Scan(buf,"%s>%s %f%s",dummy,&wert,einheit);
    change_unit(wert,einheit,min_value,unit);

    Fmt(cmd,"%s<DAT:BLOC:MAX? %i",block_nr);
    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;
    Scan(buf,"%s>%s %f%s",dummy,&wert,einheit);
    change_unit(wert,einheit,max_value,unit);

    return (0);
}
/* ========================================================================= */
/*  This function the read datalogger String                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_read_datalogger(int instrID,int sp_nr,int* block_nr,char* sp_date,
                            char* sp_time,char* value)
{
    char n1[10],n2[10];

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    Fmt(cmd,"%s<DAT:DATA:VAL? %i",sp_nr);

    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;



    if(buf[0] > '9')  /* Wenn keine Block-Nr dann Leer, Empty oder Vide =>leider ist es so!*/
     return 320;
    else
    {
	 Scan(buf,"%s>%s[t44],%s[t44],%s[t44],%s[t44],%s[t-]",n1,n2,sp_date,sp_time,value);
     Scan(n2,"%s>%i",block_nr);
    }
    return (0);
}

/* ========================================================================= */
/*  This function the read datalogger Values                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_read_datalogger_value(int instrID,int sp_nr,int* block_nr,char* sp_date,
                            char* sp_time,double* value,char* unit)
{
    char n1[10],n2[10],n3[30],einheit[30] ;
    double wert;

    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    Fmt(cmd,"%s<DAT:DATA:VAL? %i",sp_nr);

    if(bp4422_receive_scpi(instrID,cmd,buf) != 0)
      return bp4422_err;
    

    if(buf[0] > '9')  /* Wenn keine Block-Nr dann Leer, Empty oder Vide =>leider ist es so!*/
     return 320;
    else
    {
     Scan(buf,"%s>%s[t44],%s[t44],%s[t44],%s[t44],%s",n1,n2,sp_date,sp_time,n3);
     Scan(n2,"%s>%i",block_nr);
     Scan(n3,"%s>%f%s",&wert,einheit);
     change_unit(wert,einheit,value,unit);
    }
    return (0);
}
/* ========================================================================= */
/*  This function set the ramp mode                                          */
/* ========================================================================= */
int _VI_FUNC bp4422_set_ramp_mode(int instrID,int rmode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (rmode, 0, 2,  -2) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID, ramp_mode[rmode]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function set the ramp Start/ Stop                                 */
/* ========================================================================= */

int _VI_FUNC bp4422_ramp_start_stop(int instrID,int start)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (start, 0, 1,  -2) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID,ramp_start[start]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function  step ramp                                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_ramp_step(int instrID,int smode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (smode, 0, 1,  -2) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID,ramp_step[smode]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function  initiate Ramp1                                            */
/* ========================================================================= */
int _VI_FUNC bp4422_init_ramp1(int instrID,int waveform,int number,double step_time,
                      int type,double start_value,double stop_value,
                      double step_value)
{
    char unit[10];
    
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (waveform, 0, 1,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (number, 0, 99,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_real_range (step_time, 0.2, 99999.9,  -4) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (type, 0, 9,  -5) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID, ramp1_wave[waveform]) != 0)
       return bp4422_err;

    Fmt (cmd, "%s<SOUR:SWE:COUN %i",number);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    Fmt (cmd, "%s<SOUR:SWE:DWEL %f",step_time);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

	if((type == 0) || (type == 1)) /* Voltage*/
	{
	 if(type == 0) 				/* V */
	 {
	   Fmt(unit,"%s<V");
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_V,bp4422_MAX_V,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_V,bp4422_MAX_V,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_V,bp4422_MAX_V,  -8) != 0)
        return bp4422_err;
      }
      else						/* mV*/
      {
       Fmt(unit,"%s<mV");
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_MV,bp4422_MAX_MV,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_MV,bp4422_MAX_MV,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_MV,bp4422_MAX_MV,  -8) != 0)
        return bp4422_err;
      }  
      Fmt (cmd, "%s<SOUR:VOLT:STAR %f%s",start_value,unit);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:VOLT:STOP %f%s",stop_value,unit);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:VOLT:STEP %f%s",step_value,unit);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    else if(type == 2)   /* Current*/
    {
      if (bp4422_invalid_real_range (start_value, bp4422_MIN_MA,bp4422_MAX_MA,  -6) != 0)
       return bp4422_err;
      if (bp4422_invalid_real_range (stop_value, bp4422_MIN_MA,bp4422_MAX_MA,  -7) != 0)
       return bp4422_err;
      if (bp4422_invalid_real_range (step_value, bp4422_MIN_MA,bp4422_MAX_MA,  -8) != 0)
       return bp4422_err;

      Fmt (cmd, "%s<SOUR:CURR:STAR %fMA",start_value);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:CURR:STOP %fMA",stop_value);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
      Fmt (cmd, "%s<SOUR:CURR:STEP %fMA",step_value);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    else if ((type > 2) && (type < 6)) /* TC*/
    {
	 switch(type)
	 {
	  case 3:		/* C*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -8) != 0)
         return bp4422_err;
	   break;
	  case 4:		/* F*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -8) != 0)
         return bp4422_err;
	   break;
	  case 5:		/* K*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_K,bp4422_MAX_K,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_K,bp4422_MAX_K,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_K,bp4422_MAX_K,  -8) != 0)
         return bp4422_err;
	   break;
	 }  
    
     if (bp4422_send_scpi (instrID, tc_unit[type-3]) != 0)
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:TCO:STAR %f",start_value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:TCO:STOP %f",stop_value);
     if (bp4422_send_scpi (instrID, cmd) != 0) 
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:TCO:STEP %f",step_value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    else if((type > 5) && (type <= 9))  /* RTD*/
    {
	 switch(type)
	 {
	  case 6:		/* OHM*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_OHM,bp4422_MAX_OHM,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_OHM,bp4422_MAX_OHM,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_OHM,bp4422_MAX_OHM,  -8) != 0)
         return bp4422_err;
	   break;
	  case 7:		/* C*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -8) != 0)
         return bp4422_err;
	   break;
	  case 8:		/* F*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -8) != 0)
         return bp4422_err;
	   break;
	  case 9:		/* K*/
       if (bp4422_invalid_real_range (start_value, bp4422_MIN_K,bp4422_MAX_K,  -6) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (stop_value, bp4422_MIN_K,bp4422_MAX_K,  -7) != 0)
        return bp4422_err;
       if (bp4422_invalid_real_range (step_value, bp4422_MIN_K,bp4422_MAX_K,  -8) != 0)
        return bp4422_err;
	   break;
	 }  
     if (bp4422_send_scpi (instrID, rtd_unit[type-6]) != 0)
      return bp4422_err;
	 
     Fmt (cmd, "%s<SOUR:RES:STAR %f",start_value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:RES:STOP %f",stop_value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:RES:STEP %f",step_value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    return 0;
}
/* ========================================================================= */
/*  This function  initiate Ramp2                                            */
/* ========================================================================= */
int _VI_FUNC bp4422_init_ramp2(int instrID,int waveform,int number,int points)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (waveform, 0, 1,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (number, 0, 99,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (points, 2, 30,  -4) != 0)
     return bp4422_err;

    if (bp4422_send_scpi (instrID, ramp2_wave[waveform]) != 0)
      return bp4422_err;

    Fmt (cmd, "%s<SOUR:LIST:COUN %i",number);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    Fmt (cmd, "%s<SOUR:LIST:POIN %i",points);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function  initiate Ramp2 list                                        */
/* ========================================================================= */
int _VI_FUNC bp4422_init_ramp2_list(int instrID,int type,int list_nr,double value,double step_time)
{
    char unit[10];
    
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (type, 0, 9,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (list_nr, 1, 30,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_real_range (step_time, 0.1, 99999.9,  -5) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<SOUR:LIST:NUMB %d",list_nr);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<SOUR:LIST:DWEL %f",step_time);
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    if((type == 0) || (type == 1)) /* Voltage*/
    {

	  if(type == 0)
	  {
	   Fmt(unit,"%s<V");
       if (bp4422_invalid_real_range (value, bp4422_MIN_V,bp4422_MAX_V,  -4) != 0)
        return bp4422_err;
	  } 
	  else
	  {
	   Fmt(unit,"%s<MV");
       if (bp4422_invalid_real_range (value, bp4422_MIN_MV,bp4422_MAX_MV,  -4) != 0)
        return bp4422_err;
	  } 

      Fmt (cmd, "%s<SOUR:LIST:VOLT %f%s",value,unit);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    else if(type == 2)   /* Current*/
    {
      if (bp4422_invalid_real_range (value, bp4422_MIN_MA,bp4422_MAX_MA,  -4) != 0)
       return bp4422_err;

      Fmt (cmd, "%s<SOUR:LIST:CURR %fMA",value);
      if (bp4422_send_scpi (instrID, cmd) != 0)
       return bp4422_err;
    }
    else if ((type > 2) && (type < 6)) /* TC*/
    {
	 switch(type)
	 {
	  case 3:		/* C*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -4) != 0)
        return bp4422_err;
	   break;
	  case 4:		/* F*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -4) != 0)
        return bp4422_err;
	   break;
	  case 5:		/* K*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_K,bp4422_MAX_K,  -4) != 0)
        return bp4422_err;
	   break;
	 }  
     if (bp4422_send_scpi (instrID, tc_unit[type-3]) != 0)
      return bp4422_err;
    
     Fmt (cmd, "%s<SOUR:LIST:TCO %f",value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }
    else if((type > 5) && (type <= 9))  /* RTD*/
    {
	 switch(type)
	 {
	  case 6:		/* OHM*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_OHM,bp4422_MAX_OHM,  -4) != 0)
        return bp4422_err;
	   break;
	  case 7:		/* C*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_GRD_C,bp4422_MAX_GRD_C,  -4) != 0)
        return bp4422_err;
	   break;
	  case 8:		/* F*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_GRD_F,bp4422_MAX_GRD_F,  -4) != 0)
        return bp4422_err;
	   break;
	  case 9:		/* K*/
       if (bp4422_invalid_real_range (value, bp4422_MIN_K,bp4422_MAX_K,  -4) != 0)
        return bp4422_err;
       break;
	 }  
	 
     if (bp4422_send_scpi (instrID, rtd_unit[type-6]) != 0)
      return bp4422_err;

     Fmt (cmd, "%s<SOUR:LIST:RES %f",value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }
    return 0;
}

/* ========================================================================= */
/*  This function set the display backlight                                 */
/* ========================================================================= */
int _VI_FUNC bp4422_set_display_backlight(int instrID,int state,double btime)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (state, 0, 1,  -2) != 0)
     return bp4422_err;
    if (bp4422_invalid_real_range (btime, 1.0F, 60.0F,  -3) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<DISP:BACK %i",state);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    Fmt (cmd, "%s<DISP:BACK:TIME %f",btime);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function set the display contrast                                  */
/* ========================================================================= */
int _VI_FUNC bp4422_set_display_contrast(int instrID,double value)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_real_range (value, 0.0F, 1.0F,  -2) != 0)
     return bp4422_err;


    Fmt (cmd, "%s<DISP:CONT %f",value);
    if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;

    return 0;
}

/* ========================================================================= */
/*  This function return the System Error                                    */
/* ========================================================================= */
int _VI_FUNC bp4422_system_error(int instrID,char* system_error)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    if(bp4422_receive_scpi(instrID,"SYST:ERR?",system_error) != 0)
     return bp4422_err;
    return 0;
}
/* ========================================================================= */
/*  This function return the System Error                                    */
/* ========================================================================= */
int _VI_FUNC bp4422_system_keyboard(int instrID,int flag)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (flag, 0, 1,  -2) != 0)
    return bp4422_err;

    if (bp4422_send_scpi (instrID, system_keyboard[flag]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function switch the calibration state ON/OFF                        */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_state(int instrID,int state)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (state, 0, 1,  -2) != 0)
    return bp4422_err;

    if (bp4422_send_scpi (instrID, cal_state[state]) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function adjust the calibration current range ;cal_mode = 0 => low       */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_curr_adjust(int instrID,int range,int cal_mode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (range, 0, 3,  -2) != 0)
    return bp4422_err;

    if (bp4422_invalid_integer_range (cal_mode, 0, 1,  -3) != 0)
    return bp4422_err;

    if(cal_mode == 0)    /* LOW*/
    {
     if (bp4422_send_scpi (instrID, cal_curr_low[range]) != 0)
      return bp4422_err;
    }
    else
    {
     if (bp4422_send_scpi (instrID, cal_curr_high[range]) != 0)
      return bp4422_err;
    }

    return 0;
}
/* ========================================================================= */
/*  This function adjust the calibration voltage range                        */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_volt_adjust(int instrID,int range,int cal_mode)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (range, 0, 7,  -2) != 0)
    return bp4422_err;
    if (bp4422_invalid_integer_range (cal_mode, 0, 1,  -3) != 0)
    return bp4422_err;

    if(cal_mode ==  0)  /* low*/
    {
     if (bp4422_send_scpi (instrID, cal_volt_low[range]) != 0)
      return bp4422_err;
    }
    else
    {
     if (bp4422_send_scpi (instrID, cal_volt_high[range]) != 0)
      return bp4422_err;
    }

    return 0;
}
/* ========================================================================= */
/*  This function set the calibration current data                          */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_curr_data(int instrID,double low_data,double high_data)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    Fmt (cmd, "%s<CAL:CURR %f[p10]MA,%f[p10]MA",low_data*1000.0F,
                                                high_data*1000.0F);

    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return 0;
}


/* ========================================================================= */
/*  This function set the calibration voltage data                          */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_volt_data(int instrID,double low_data,double high_data)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    Fmt (cmd, "%s<CAL:VOLT %f[p10]V,%f[p10]V",low_data,high_data);

    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function adjust the calibration rref                                */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_rref(int instrID,int cal_mode,double value)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (cal_mode, 0, 1,  -3) != 0)
     return bp4422_err;

    if(cal_mode ==  0)  /* low*/
    {
     Fmt (cmd, "%s<CAL:RREF:LOW %fOHM",value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }
    else
    {
     Fmt (cmd, "%s<CAL:RREF:HIGH %fOHM",value);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }

    return 0;
}
/* ========================================================================= */
/*  This function adjust the calibration PT100                               */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_pt100(int instrID)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;

    Fmt (cmd, "%s<CAL:PT100");
    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return 0;
}
/* ========================================================================= */
/*  This function adjust the calibration PTD                                */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_rtd_adjust(int instrID,int cal_mode,int curr_mode,int range)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (cal_mode, 0, 1,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (curr_mode, 0, 1,  -3) != 0)
     return bp4422_err;
    if (bp4422_invalid_integer_range (range, 0, 1,  -3) != 0)
     return bp4422_err;

    if(cal_mode ==  0)  /* low*/
    {
     Fmt (cmd, "%s<CAL:RTD:LOW %s,%s",rtd_currmode[curr_mode],
                                      rtd_range[range]);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }
    else
    {
     Fmt (cmd, "%s<CAL:RTD:HIGH %s,%s",rtd_currmode[curr_mode],
                                      rtd_range[range]);
     if (bp4422_send_scpi (instrID, cmd) != 0)
      return bp4422_err;
    }

    return 0;
}
/* ========================================================================= */
/*  This function set the calibration RTD data                               */
/* ========================================================================= */
int _VI_FUNC bp4422_cal_rtd_data(int instrID,double low_data,double high_data)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
    return bp4422_err;

    Fmt (cmd, "%s<CAL:RTD %f[p10],%f[p10]",low_data,high_data);

    if (bp4422_send_scpi (instrID, cmd) != 0)
     return bp4422_err;

    return 0;
}
/*=========================================================================*/
/* This function check the device dependent error flag                     */
/*=========================================================================*/
int _VI_FUNC bp4422_get_eoc(int instrID)
{
    int ret,meas_status;
    double t1,t2,diff;

    ret = 0;
    t1= Timer();                                /* startzeit merken */
    bp4422_err = 0;

	diff = 0.0F;								// Variablenwert initialisiert (MT/25.11.2002)

    while((ret != 1) && (diff < 30.0F))
    {
     Delay(0.1F);
     if(bp4422_receive_scpi(instrID,":STAT:OPER:COND?",buf) != 0)
      return bp4422_err;
     Scan(buf,"%s>%i",&meas_status);

     /*FmtOut("\n Stat Oper cond %s ",buf);*/

     /*--------------- Messung berhaupt gestartet-------------*/
     if(!(meas_status & bp4422_DEVICE_MEASURING))
     {
      ret = 1;
      bp4422_err = 350;
     }
     /*--------------- Messung Fertig -------------*/
     if(meas_status & bp4422_DEVICE_EOC)
     {
      ret = 1;
      bp4422_err = 0;
      /*FmtOut("\n** EOC **");*/
     }

     t2= Timer();
     diff = fabs(t2-t1);
    }
    if(diff >= 30.0F)
     bp4422_err = 351;

    return (bp4422_err);
}
/*=========================================================================*/
/* This function check the device presure eoc flag                     */
/*=========================================================================*/
int _VI_FUNC bp4422_get_p_eoc(int instrID)
{
    int ret,meas_status;
    double t1,t2,diff;

    ret = 0;
    t1= Timer();                                /* startzeit merken */
    bp4422_err = 0;
	diff = 0.0F;								// Variablenwert initialisiert (MT/25.11.2002)

    while((ret != 1) && (diff < 30.0F))
    {
     Delay(0.1F);
     if(bp4422_receive_scpi(instrID,":STAT:OPER:COND?",buf) != 0)
      return bp4422_err;
     Scan(buf,"%s>%i",&meas_status);

     /*FmtOut("\n Stat Oper cond %s ",buf);*/

     /*--------------- Messung berhaupt gestartet-------------*/
     if(!(meas_status & bp4422_DEVICE_MEASURING))
     {
      ret = 1;
      bp4422_err = 350;
     }
     /*--------------- Druck-Messung Fertig -------------*/
     if(meas_status & bp4422_DEVICE_P_EOC)
     {
      ret = 1;
      bp4422_err = 0;
      /*FmtOut("\n** P-EOC **");*/
     }

     t2= Timer();
     diff = fabs(t2-t1);
    }
    if(diff >= 30.0F)
     bp4422_err = 351;

    return (bp4422_err);
}

/*=========================================================================*/
/* This function check the device dependent error flag                     */
/*=========================================================================*/
int _VI_FUNC bp4422_get_status(int instrID)
{
      int status_flag;
      
	  bp4422_status_quest_reg = 0;
      bp4422_err = 0;

      /* Ab DIGI-VAl 2.0 wird ESR nicht mehr abgefragt*/ 
   
   /*   if(bp4422_receive_scpi(instrID,"*ESR?",buf) != 0)	 
       return bp4422_err;

      FmtOut("\n Standard Event :%s ",buf);

      Scan(buf,"%s>%i",&status_flag);
      if(status_flag & bp4422_DEVICE_DEPT_ERROR)
      {
       if(status_flag & bp4422_EXECUTION_ERROR)
       {
        bp4422_err = 309;   
        return bp4422_err;
       }																*/

       if(bp4422_receive_scpi(instrID,"STAT:QUES:COND?",buf) != 0)		/* Questionable Register abfragen*/
        return bp4422_err;

       /*FmtOut("\n Quest Stat :%s ",buf);   */

       Scan(buf,"%s>%i",&bp4422_status_quest_reg);

       if(bp4422_status_quest_reg == 0)
       {
        bp4422_err = 0;    /* NO ERROR */
        return bp4422_err;
       }
       if((bp4422_status_quest_reg & bp4422_IN_OVER_ERROR) && (bp4422_status_quest_reg & bp4422_OUT_OVER_ERROR))
       {
        bp4422_err = 317;    /* Input and Output Over ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_IN_OVER_ERROR)
       {
        bp4422_err = 314;    /* Input Over ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_OUT_OVER_ERROR)
       {
        bp4422_err = 315;    /* Output Over ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_VOLTAGE_ERROR)
       {
        bp4422_err = 310;    /* Voltage ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_CURRENT_ERROR)
       {
        bp4422_err = 311;    /* Current ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_TEMP_ERROR)
       {
        bp4422_err = 312;    /* Tempature ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_CAL_ERROR)
       {
        bp4422_err = 313;    /* Calibration ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_LOW_BAT_ERROR)
       {
        bp4422_err = 316;    /* Lowbat ERROR */
        return bp4422_err;
       }
       if(bp4422_status_quest_reg & bp4422_P_OVER_ERROR)
       {
        bp4422_err = 318;    /* Presure Over ERROR */
        return bp4422_err;
       }
       
      /*}*/
      return bp4422_err;
}
/*=========================================================================*/
/* This function check the operaton status register                        */
/*=========================================================================*/
int _VI_FUNC bp4422_get_cal_status(int instrID,int* status)
{
      int cal_status;

      bp4422_err = 0;

      if(bp4422_receive_scpi(instrID,"STAT:OPER?",buf) != 0)
       return bp4422_err;

/*      FmtOut("\n Quest Stat :%s ",buf);*/

      Scan(buf,"%s>%i",&cal_status);
      if(cal_status & bp4422_DEVICE_CALIBRATION)
       *status = 1;
      else
       *status = 0;

      return bp4422_err;
}
/*=========================================================================*/
/* This function check the cal error registers                             */
/*=========================================================================*/
int _VI_FUNC bp4422_get_cal_err(int instrID,int* err_status,int* err_code)
{
      int status;

      *err_status = 0;
      *err_code = 0;
      bp4422_err = 0;

      if(bp4422_receive_scpi(instrID,"CST:I?",buf) != 0)
       return bp4422_err;

      Scan(buf,"%s>%i",&status);
      if(status != 0)
      {
       *err_status = 400;
       *err_code = status;
       return bp4422_err;
      }

      if(bp4422_receive_scpi(instrID,"CST:U:IN?",buf) != 0)
       return bp4422_err;
      Scan(buf,"%s>%i",&status);
      if(status != 0)
      {
       *err_status = 401;
       *err_code = status;
       return bp4422_err;
      }

      if(bp4422_receive_scpi(instrID,"CST:U:OUT?",buf) != 0)
       return bp4422_err;
      Scan(buf,"%s>%i",&status);
      if(status != 0)
      {
       *err_status = 402;
       *err_code = status;
       return bp4422_err;
      }


      if(bp4422_receive_scpi(instrID,"CST:R:IN?",buf) != 0)
       return bp4422_err;
      Scan(buf,"%s>%i",&status);
      if(status != 0)
      {
       *err_status = 403;
       *err_code = status;
       return bp4422_err;
      }

      if(bp4422_receive_scpi(instrID,"CST:R:OUT?",buf) != 0)
       return bp4422_err;
      Scan(buf,"%s>%i",&status);
      if(status != 0)
      {
       *err_status = 404;
       *err_code = status;
       return bp4422_err;
      }
      return bp4422_err;
}


/*=========================================================================*/
/* This function SendSCPI                                                  */
/*=========================================================================*/
int _VI_FUNC bp4422_send_scpi(int instrID,char* send_buffer)
{
   bp4422_err = 0;

   Fmt(cmd,"%s<%s\n",send_buffer);

   bp4422_err = bp4422_send_x3_28(instrID,"sr",cmd);
   if(bp4422_err != 0)
    return (bp4422_err);


   return(0);
}
/*=========================================================================*/
/* This function receive SCPI                                              */
/*=========================================================================*/
int _VI_FUNC bp4422_receive_scpi(int instrID,char* send_buffer,char* receive_buffer)
{
   bp4422_err = 0;

   Fmt(cmd,"%s<%s\n",send_buffer);

  /* FmtOut("\n++%s++",cmd);*/

   bp4422_err = bp4422_send_x3_28(instrID,"sr",cmd);
   if(bp4422_err != 0)
    return (bp4422_err);

   bp4422_err = bp4422_receive_x3_28(instrID,"po","",receive_buffer);
   if(bp4422_err != 0)
     return (bp4422_err);
  /* FmtOut("\n**%s**",receive_buffer);*/

   return(0);
}
/* ========================================================================= */
/*  This function closes the instrument.                                     */
/* ========================================================================= */
int _VI_FUNC bp4422_close (int instrID)
{
    bp4422_err = 0;

    if (bp4422_invalid_integer_range (instrID, 1, bp4422_MAX_INSTR,  -1) != 0)
     return (bp4422_err);

    if (bp4422_device_closed(instrID) != 0)
     return (bp4422_err);
    bp4422_close_instr(instrID);

    return (bp4422_err);
}
/* = SERIAL UTILITY ROUTINES ============================================== */
/* ========================================================================= */
/*  This function locates and initializes an entry in the Instrument Table   */
/*  and the device table for the instrument.  If successful, the            */
/*  instrument ID is returned, else a -1 is returned.  The size of the       */
/*  Instrument Table can be changed in the include file by altering the      */
/*  constant bp4422_MAX_INSTR.                                               */
/* ========================================================================= */
int _VI_FUNC bp4422_open_instr(int port,int baud_rate,int g_addr,int u_addr)
{
    int i, instrID;

    instrID = 0;

    /*--Check to see if the instrument is already in the Instrument Table.-*/

    for (i=1; i< bp4422_MAX_INSTR; i++)
    {
/*    FmtOut("\n g_adr %i u_adr %i i= %i",dev_group_addr[i],dev_user_addr[i],i);*/
     if((dev_group_addr[i] == g_addr) && (dev_user_addr[i] == u_addr))
     {
        instrID = i;
    	i = bp4422_MAX_INSTR;
     }
    }

   /*------ If it is not in the instrument table, open an entry for the
            instrument. ---------------------------------------------------*/

    if (instrID <= 0)
    {
     for (i=1; i< bp4422_MAX_INSTR; i++)
     {
/*     FmtOut("\n g_adr %i u_adr %i i= %i",dev_group_addr[i],dev_user_addr[i],i);*/
        if( (dev_group_addr[i] < 0) && (dev_user_addr[i] < 0))
        {
         instrID = i;
     	 i = bp4422_MAX_INSTR;
        }
     }
    }

    /*----- If an entry could not be opened in the Instrument Table,
            return an error.-----------------------------------------------*/

    if (instrID <= 0)
    {
     bp4422_err = 220;
     return -1;
    }


    dev_port[instrID] = port;

    OpenComConfig (dev_port[instrID], "", baud_rate,0, 8, 1, 512, 512);

    if (rs232err != 0)
    {
     bp4422_err = rs232err;

     CloseCom (dev_port[instrID]);

     dev_port[instrID] = 0;
     dev_group_addr[instrID] = -1;
     dev_user_addr[instrID] = -1;
    
     return (-1);
    }
    dev_group_addr[instrID] = g_addr;
    dev_user_addr[instrID] = u_addr;
    return instrID;
}
/*=========================================================================*/
/* Function: Close Instrument                                              */
/* Purpose:  This function closes the instrument by removing it from the   */
/*           device table and setting the address and the bd to zero       */
/*           in the Instrument Table.  The return value is equal to the    */
/*           global error variable.                                        */
/*=========================================================================*/
int _VI_FUNC bp4422_close_instr(int instrID)
{
    if( (dev_group_addr[instrID] >= 0) && (dev_user_addr[instrID] >= 0))
    {
      CloseCom (dev_port[instrID]);

      dev_port[instrID] = 0;
      dev_group_addr[instrID] = -1;
      dev_user_addr[instrID] = -1;
    }
    else
     bp4422_err = 221;

    return bp4422_err;
 }
/*=========================================================================*/
/* Function: Device Closed                                                 */
/* Purpose:  This function checks to see if the module has been            */
/*           initialized.  If the device has not been opened, a 1 is       */
/*           returned, 0 otherwise.                                        */
/*=========================================================================*/
int _VI_FUNC bp4422_device_closed(int instrID)
{
     if( (dev_group_addr[instrID] < 0) && (dev_user_addr[instrID] < 0))
     {
    	bp4422_err = 232;
        return -1;
     }
     return 0;
}

/*=========================================================================*/
/* This function send a comand and message and wait for ACK                */
/*=========================================================================*/
int _VI_FUNC bp4422_send_x3_28(int instrID,char* cmd,char* msg)
{
    int ret,r_byte;

    FlushInQ(dev_port[instrID]);           /* Clear Port */

    /*FmtOut("\nmsg ++%s++",msg);*/

    bcc_repeat = 0;
    for(;;)
    {
     ret = bp4422_send_x3_28_message(instrID,cmd,msg);
     if(ret != 0)
       return (ret);     /* ERROR*/

     r_byte = ComRdByte(dev_port[instrID]);
     if (rs232err != 0)
      return (231);


    /* FmtOut("\nsend_x3_28 ret %c %d\n",r_byte,bcc_repeat);*/


     Delay(0.01);

     switch(r_byte)
     {
      case ACK:
       return  (0);
       break;
      case NAK:
       if(bcc_repeat >= max_bcc_repeat)
        return (300);                /* NAK => MAX Repeat */
       bcc_repeat++;
       break;
      case EOT:
       return (301);
       break;
     }
    }

    return (0);
}

/*=========================================================================*/
/* This function send comand and message and receive a string              */
/*=========================================================================*/
int _VI_FUNC bp4422_receive_x3_28(int instrID,char* cmd,char* msg,char* receive_buf)
{
    int ret;

    FlushInQ(dev_port[instrID]);           /* Clear Port */
    ret = bp4422_send_x3_28_message(instrID,cmd,msg);
    if(ret != 0)
      return (ret);     /* ERROR*/

    ret = bp4422_receive_and_ack(instrID,receive_buf);
    if(ret != 0)
      return (ret);     /* ERROR*/

    ComRdByte(dev_port[instrID]);   /* Read the EOT from Port*/

    return(0);
}
/*=========================================================================*/
/* This function receive a string                                          */
/*=========================================================================*/
int _VI_FUNC bp4422_receive_and_ack(int instrID,char* receive_buf)
{
    int r_byte,r_bcc,bcc,l,first_byte;

    bcc_repeat = 0;
    for(;;)
    {
     first_byte = ComRdByte(dev_port[instrID]);   /* Read the EOT or STX from Port*/
     if(first_byte == EOT)
      return (301);

     r_byte = ComRdTerm(dev_port[instrID],in_buf,bp4422_MAX_CMD-1,ETX);/* Read to ETX*/
     if (rs232err != 0)
      return (231);

     if(bcc_state == 1)
     {
      r_bcc = ComRdByte(dev_port[instrID]);   /* Read the BCC from Port*/
      if (rs232err != 0)
       return (231);
     }
     in_buf[r_byte] = ETX;            /* Calculate bcc with ETX */
     in_buf[r_byte+1] = NUL;          /* Terminate the String*/
     l = StringLength(in_buf);

/*     FmtOut("\nread in %c %s %d",first_byte,in_buf,l);*/


     CopyString (swap_buf, 0,in_buf, 0, l);   /* calculate bcc without STX */
     if(bcc_state == 1)
     {
      bcc = bp4422_calculate_bcc(swap_buf);
      if(r_bcc != bcc)
      {
       ComWrtByte(dev_port[instrID],NAK);
       if(bcc_repeat >= max_bcc_repeat)
        return (300);                /* NAK => MAX Repeat */
       bcc_repeat++;
      }
      else
      {
       ComWrtByte(dev_port[instrID],ACK);
       CopyString (receive_buf, 0,in_buf,0,l-3); /* Copy without LF,ETX*/
       return(0);                /* 0 = ACK == OK*/
      }
     }
     else    /* Without bcc check*/
     {
      ComWrtByte(dev_port[instrID],ACK);
      CopyString (receive_buf, 0,in_buf,0,l-3); /* Copy without LF,ETX*/
      return(0);                /* 0 = ACK == OK*/
     }
    }

    return(0);
}

/*=========================================================================*/
/* This function send a comand and message                                 */
/*=========================================================================*/
int _VI_FUNC bp4422_send_x3_28_message(int instrID,char* cmd,char* msg)
{
    int ret,l;
    int bcc;

    ret = CompareStrings (msg, 0,"", 0, 0); /* Send a command without msg ?*/
    if(ret == 0)
     Fmt(out_buf,"%s<%c%x%x%x%x%s%c", EOT,
                                      dev_group_addr[instrID],
                                      dev_group_addr[instrID],
                                      dev_user_addr[instrID],
                                      dev_user_addr[instrID],
                                      cmd,ENQ); /* without msg*/
    else
    {
     Fmt(swap_buf ,"%s<%s%c",msg,ETX);   /* with msg*/
     if(bcc_state == 1)
     {
      bcc = bp4422_calculate_bcc(swap_buf);
      Fmt(out_buf,"%s<%c%x%x%x%x%s%c%s%c", EOT,
                                           dev_group_addr[instrID],
                                           dev_group_addr[instrID],
                                           dev_user_addr[instrID],
                                           dev_user_addr[instrID],
                                           cmd,STX,swap_buf,bcc);
     }
     else
      Fmt(out_buf,"%s<%c%x%x%x%x%s%c%s", EOT,
                                         dev_group_addr[instrID],
                                         dev_group_addr[instrID],
                                         dev_user_addr[instrID],
                                         dev_user_addr[instrID],
                                         cmd,STX,swap_buf);
    }

/* FmtOut("\nsend_x3_28_Message %s",out_buf);*/


    l = StringLength(out_buf);
    ret = ComWrt(dev_port[instrID], out_buf, l);     /* Write the Message */
    if (rs232err != 0)
     return (230);

    return (0);
}
/*=========================================================================*/
/* This function calculate the block check                                 */
/*=========================================================================*/
int _VI_FUNC bp4422_calculate_bcc(char* msg)
{
    int l,i,bcc;

    bcc = 0;
    l = StringLength(msg);
    for(i = 0;i <= l;i++)
     bcc ^= msg[i];     /* exclusive OR */

    bcc |= 0x80;    /* OR Bit 8 */

    return (bcc);
}

/* = Global UTILITY ROUTINES ==============================================*/
/*=========================================================================*/
/* Function: Invalid Integer Range                                         */
/* Purpose:  This function checks an integer to see if it lies between a   */
/*           minimum and maximum value.  If the value is out of range, set */
/*           the global error variable to the value err_code.  If the      */
/*           value is OK, error = 0.                                       */
/*=========================================================================*/
int _VI_FUNC bp4422_invalid_integer_range (int val,int min,int max,int err_code)
{
  if ((val < min) || (val > max))
  {
    bp4422_err = err_code;
    return -1;
  }
  return 0;
}
/*=========================================================================*/
/* Function: Invalid Real Range                                            */
/* Purpose:  This function checks a real number to see if it lies between  */
/*           a minimum and maximum value.  If the value is out of range,   */
/*           set the global error variable to the value err_code.  If the  */
/*           value is OK, error = 0.                                       */
/*=========================================================================*/
int _VI_FUNC bp4422_invalid_real_range (double val,double min,double max,int err_code)
{
  if ((val < min) || (val > max))
  {
    bp4422_err = err_code;
    return -1;
  }
  return 0;
}



void bp4422_setup_arrays (void)
{
    int i;

    if(!setup_first)/*----------- Reset the Arrays before initial --------*/
    {
     for (i=1; i< bp4422_MAX_INSTR; i++)
     {
       dev_group_addr[i] = -1;
       dev_user_addr[i]  = -1;
       dev_port[i]       =  0;
     }
     setup_first = 1;
    }
    port_addr[0] = 0x3f8;
    port_addr[1] = 0x2f8;
    port_addr[2] = 0x3e8;
    port_addr[3] = 0x2e8;

    int_level[0] = 4;
    int_level[1] = 3;
    int_level[2] = 4;
    int_level[3] = 3;

    /*  voltage range  */
    volt_range[0] = "SOUR:VOLT:RANG:AUTO ON";
    volt_range[1] = "SOUR:VOLT:RANG 5MV";
    volt_range[2] = "SOUR:VOLT:RANG 50MV";
    volt_range[3] = "SOUR:VOLT:RANG 500MV";
    volt_range[4] = "SOUR:VOLT:RANG 5V";

    /*  current range  */
    curr_range[0] = "SOUR:CURR:RANG:AUTO ON";
    curr_range[1] = "SOUR:CURR:RANG 1MA";
    curr_range[2] = "SOUR:CURR:RANG 10MA";

    /*  resistance range  */
    res_range[0] = "SOUR:RES:RANG:AUTO ON";
    res_range[1] = "SOUR:RES:RANG 100OHM";
    res_range[2] = "SOUR:RES:RANG 1KOHM";

    /*  IO-mode */
    io_mode[0] = "INST:NSEL 0";  /* Geber Mode*/
    io_mode[1] = "INST:NSEL 1";  /* Mess Mode*/


    /*  SYSTEM Keyboard  */
    system_keyboard[0] = "SYST:KLOC OFF";
    system_keyboard[1] = "SYST:KLOC ON";

    /*  Calibration   */
    cal_state[0] = "CAL:STAT OFF";
    cal_state[1] = "CAL:STAT ON";


    cal_volt_low[0] = "CAL:VOLT:LOW 10MV";
    cal_volt_low[1] = "CAL:VOLT:LOW -10MV";
    cal_volt_low[2] = "CAL:VOLT:LOW 100MV";
    cal_volt_low[3] = "CAL:VOLT:LOW -100MV";
    cal_volt_low[4] = "CAL:VOLT:LOW 1V";
    cal_volt_low[5] = "CAL:VOLT:LOW -1V";
    cal_volt_low[6] = "CAL:VOLT:LOW 11V";
    cal_volt_low[7] = "CAL:VOLT:LOW -11V";

    cal_volt_high[0] = "CAL:VOLT:HIGH 10MV";
    cal_volt_high[1] = "CAL:VOLT:HIGH -10MV";
    cal_volt_high[2] = "CAL:VOLT:HIGH 100MV";
    cal_volt_high[3] = "CAL:VOLT:HIGH -100MV";
    cal_volt_high[4] = "CAL:VOLT:HIGH 1V";
    cal_volt_high[5] = "CAL:VOLT:HIGH -1V";
    cal_volt_high[6] = "CAL:VOLT:HIGH 11V";
    cal_volt_high[7] = "CAL:VOLT:HIGH -11V";

    cal_curr_low[0] = "CAL:CURR:LOW 2MA";
    cal_curr_low[1] = "CAL:CURR:LOW -2MA";
    cal_curr_low[2] = "CAL:CURR:LOW 22MA";
    cal_curr_low[3] = "CAL:CURR:LOW -22MA";

    cal_curr_high[0] = "CAL:CURR:HIGH 2MA";
    cal_curr_high[1] = "CAL:CURR:HIGH -2MA";
    cal_curr_high[2] = "CAL:CURR:HIGH 22MA";
    cal_curr_high[3] = "CAL:CURR:HIGH -22MA";

    rtd_currmode[0] = "ILOW";
    rtd_currmode[1] = "IHIGH";

    rtd_range[0]    = "200OHM";
    rtd_range[1]    = "2KOHM" ;

    rtd[0]    = "CONF:TEMP:FRTD PT100";
    rtd[1]    = "CONF:TEMP:FRTD NI100";
    rtd[2]    = "CONF:TEMP:FRTD PT200";
    rtd[3]    = "CONF:TEMP:FRTD PT500";
    rtd[4]    = "CONF:TEMP:FRTD PT1000";

    rtd_unit[0]  = "UNIT:TEMP:FRTD OHM";
    rtd_unit[1]  = "UNIT:TEMP:FRTD C" ;
    rtd_unit[2]  = "UNIT:TEMP:FRTD F" ;
    rtd_unit[3]  = "UNIT:TEMP:FRTD K" ;

    tc[0]    = "CONF:TEMP:TCO R";
    tc[1]    = "CONF:TEMP:TCO S";
    tc[2]    = "CONF:TEMP:TCO B";
    tc[3]    = "CONF:TEMP:TCO J";
    tc[4]    = "CONF:TEMP:TCO T";
    tc[5]    = "CONF:TEMP:TCO E";
    tc[6]    = "CONF:TEMP:TCO K";
    tc[7]    = "CONF:TEMP:TCO U";
    tc[8]    = "CONF:TEMP:TCO L";
    tc[9]    = "CONF:TEMP:TCO N";
    tc[10]    = "CONF:TEMP:TCO C";
    tc[11]    = "CONF:TEMP:TCO D";
    tc[12]    = "CONF:TEMP:TCO G2";
    tc[13]    = "CONF:TEMP:TCO M";

    tc_unit[0]  = "UNIT:TEMP:TCO C";
    tc_unit[1]  = "UNIT:TEMP:TCO F";
    tc_unit[2]  = "UNIT:TEMP:TCO K";


    tc_rj_output[0]    = "TC";
    tc_rj_output[1]    = "TC+RJ-MAN";
    tc_rj_output[2]    = "TC+RJ-AUT";
    tc_rj_output[3]    = "TC+4-20MA";
    tc_rj_output[4]    = "TC+0-20MA";

    tc_rj_input[0]    = "RJ-INT";
    tc_rj_input[1]    = "RJ-MAN";
    tc_rj_input[2]    = "RJ-EXT";
    tc_rj_input[3]    = "4-20MA";
    tc_rj_input[4]    = "0-20MA";


    ground[0]    = "INP:LOW FLO";
    ground[1]    = "INP:LOW GRO";
    ground[2]    = "INP:LOW AUTO";

    datalogger_start[0] = "DAT:STOP";
    datalogger_start[1] = "DAT:STAR";

    ramp_mode[0] = "SOUR:MODE FIX";
    ramp_mode[1] = "SOUR:MODE SWE";
    ramp_mode[2] = "SOUR:MODE LIST";

    ramp_start[0] = "RAMP:STOP";
    ramp_start[1] = "RAMP:STAR";

    ramp_step[0] = "RAMP:STEP UP";
    ramp_step[1] = "RAMP:STEP DOWN";

    ramp1_wave[0] = "SOUR:SWE:WAV SAWT";
    ramp1_wave[1] = "SOUR:SWE:WAV TRI";

    ramp2_wave[0] = "SOUR:LIST:WAV SAWT";
    ramp2_wave[1] = "SOUR:LIST:WAV TRI";
	
}
/*=========================================================================*/
/* Function: Change Unit                                                   */
/* Purpose:  Umrechung in Standard Einheit                                 */
/*=========================================================================*/
void change_unit(double wert,char* einheit,double* value,char *unit)
{
    int l;

    l = StringLength(einheit);
    if(l > 1)   /* wenn mehr als ein zeichen ist, dann selectieren*/
    {
     switch(einheit[0])
     {
      case 'M':   /*milli*/
       *value = wert / 1000.0F;
       CopyString (unit, 0, einheit, 1, l);
       break;
      case 'K':  /* Kilo*/
       *value = wert * 1000.0F;
       CopyString (unit, 0, einheit, 1, l);
       break;
      default:
       *value = wert;
       CopyString (unit, 0, einheit, 0, l);
       break;
     }
    }
    else
    {
     *value = wert;
     CopyString (unit, 0, einheit, 0, l);
    }
}
/*=========================================================================*/
/* Function: Change character pc => display 4422                           */
/* Purpose:  Wandelt die Sonderzeichen von PC-Ziechensatz in den Display-  */
/*           Zeichensatz um												   */
/*=========================================================================*/
void change_character_pc_disp4422(char* source,char *dest)
{
	int l,i = 0;

    
	l = (int)strlen(source);
	
    for( i = 0; i < l;i++)
    {
    	switch(source[i])
    	{
    	 default:
    	  dest[i] = source[i];
    	  break;
    	 case '':
    	  dest[i] = 0xE1;
    	  break;
    	 case '':
    	  dest[i] = 0xEF;
    	  break;
    	 case '':
    	  dest[i] = 0xF5;
    	  break;
    	 case '':
    	  dest[i] = 0xE2;
    	  break;
    	 case '':
    	  dest[i] = 0xE4;
    	  break;
    	 case '':
    	  dest[i] = 0xDF;
    	  break;
		}
    }
    dest[i] = 0x00;
}
/*=========================================================================*/
/* Function: Change character display 4422 => pc                           */
/* Purpose:  Wandelt die Sonderzeichen von Display-Ziechensatz in den PC-  */
/*           Zeichensatz um												   */
/*=========================================================================*/
void change_character_disp4422_pc(char* source,char *dest)
{
	int l,i = 0;
    
	l = (int)strlen(source);
	
    for( i = 0; i < l;i++)
    {
	switch((unsigned char)source[i])
    	{
    	 default:
    	  dest[i] = source[i];
    	  break;
    	 case 0xE1:
    	  dest[i] = '';
    	  break;
    	 case 0xEF:
    	  dest[i] = '';
    	  break;
    	 case 0xF5:
    	  dest[i] = '';
    	  break;
    	 case 0xE2:
    	  dest[i] = '';
    	  break;
    	 case 0xE4:
    	  dest[i] = '';
    	  break;
    	 case 0xDF:
    	  dest[i] = '';
    	  break;
		}
    }
    dest[i] = 0x00;
}
